/*
 * @brief SCTimer/PWM (SCT) Simple PWM example
 *
 * @note
 * Copyright(C) NXP Semiconductors, 2014
 * All rights reserved.
 *
 * @par
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * LPC products.  This software is supplied "AS IS" without any warranties of
 * any kind, and NXP Semiconductors and its licensor disclaim any and
 * all warranties, express or implied, including all implied warranties of
 * merchantability, fitness for a particular purpose and non-infringement of
 * intellectual property rights.  NXP Semiconductors assumes no responsibility
 * or liability for the use of the software, conveys no license or rights under any
 * patent, copyright, mask work right, or any other intellectual property rights in
 * or to any products. NXP Semiconductors reserves the right to make changes
 * in the software without notification. NXP Semiconductors also makes no
 * representation or warranty that such application will be suitable for the
 * specified use without further testing or modification.
 *
 * @par
 * Permission to use, copy, modify, and distribute this software and its
 * documentation is hereby granted, under NXP Semiconductors' and its
 * licensor's relevant copyrights in the software, without fee, provided that it
 * is used in conjunction with NXP Semiconductors microcontrollers.  This
 * copyright, permission, and disclaimer notice must appear in all copies of
 * this code.
 */

#include "board.h"


/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/

/*****************************************************************************
 * Public functions
 ****************************************************************************/

void SCT_Init(void)
{

	Chip_SCT_Init(LPC_SCT);			                   											// enable the SCT clock

	Chip_SCT_Config(LPC_SCT, SCT_CONFIG_16BIT_COUNTER	|	 								// two 16-bit timers
							  SCT_CONFIG_AUTOLIMIT_L	);														// auto limit

	Chip_Clock_SetMain_A_ClockSource(SYSCON_MAIN_A_CLKSRC_FRO12MHZ);		// Set Main Clock (SCT Clock) as 12MHz
	Chip_SCT_SetControl(LPC_SCT, SCT_CTRL_PRE_L(11));					    			// PRE_L[12:5] = 12-1 (SCT clock = 12MHz/12 = 1MHz)


	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_0, 9);										// match 0 @ 10/1MHz = 10 usec (100 KHz PWM freq)
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_1, 5);										// match 1 used for duty cycle (in 10 steps)


	Chip_SCT_EventStateMask(LPC_SCT, 0, ENABLE_ALL_STATES);							// event 0 happens in all states
	Chip_SCT_EventControl(LPC_SCT, 0 , SCT_EVECTRL_MATCH0);							// match 0 condition only


	Chip_SCT_EventStateMask(LPC_SCT, 1, ENABLE_ALL_STATES);							// event 1 happens in all states
	Chip_SCT_EventControl(LPC_SCT, 1 , SCT_EVECTRL_MATCH1);							// match 1 condition only


	Chip_SCT_SetOutput(LPC_SCT, SCT_OUTPUT_4, SCT_EVT_0 );							// event 0 will set   SCT_OUT4
	Chip_SCT_ClearOutput(LPC_SCT, SCT_OUTPUT_4, SCT_EVT_1);							// event 1 will clear SCT_OUT4


    Chip_SCT_ClearControl(LPC_SCT, SCT_CTRL_HALT_L);									// start timer
}



int main(void)
{

	static uint8_t trgsw1 = 1;
	static uint8_t trgsw2 = 1;


																																																																																																																																																					SystemCoreClockUpdate();
  	Board_Init();

  	Chip_IOCON_PinMuxSet(LPC_IOCON, 1, 10, IOCON_FUNC3 | IOCON_MODE_INACT | IOCON_DIGITAL_EN | IOCON_INPFILT_OFF);		//SCT0_OUT4 = P1.10  (green   LED)

    SCT_Init();                                           						// Initialize SCT3

    while (1)                                              						// loop forever
    {
    	 if (!Chip_GPIO_GetPinState(LPC_GPIO, 0,24) && trgsw1)      		// P0_24 (SW1) high to low?
    	 {
    	     trgsw1 = 0;                                     						// trigger SW1 low
    	     if (LPC_SCT->MATCHREL[1].L < 9)
    	        LPC_SCT->MATCHREL[1].L ++;                 							// increase PWM dutycycle
    	 }
    	 else if (Chip_GPIO_GetPinState(LPC_GPIO, 0,24) && !trgsw1)  		// P0_24 (SW1) low to high?
    	 {
    	       trgsw1 = 1;                                        			// trigger SW1 high
    	 }

    	 if (!Chip_GPIO_GetPinState(LPC_GPIO, 0,31) && trgsw2)        	// P0_31 (SW2) high to low?
    	 {
    	       trgsw2 = 0;                                        			// trigger SW3 low
    	       if (LPC_SCT->MATCHREL[1].L > 0)
    	            LPC_SCT->MATCHREL[1].L --;													// decrease PWM dutycycle
    	 }
    	 else if (Chip_GPIO_GetPinState(LPC_GPIO, 0,31) && !trgsw2)   	// P0_31 (SW2) low to high?
    	 {
    	       trgsw2 = 1;                                        			// trigger SW3 high
    	 }
    }
}
